 ; Ŀ
 ;   WireTagR - put a block on a the other side of a horizontal or         
 ;   vertical wire from the matching routine Wiretag.lsp.                  
 ;   Copyright 2000, 2001, 2010 by Rocket Software Ltd.                    
 ;                                                                         
 ; 
 (DEFUN C:WIRETAGR (/ scal pa pb ss enam entt ten elv angg)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Don't use a dialog box.  Maybe this should be set globally.           
 ; 
  (setvar "attdia" 0)
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
 ; Ŀ
 ;   Get the scale, depending on which space we are in and other things.   
 ; 
  (if misps
      (setq scal (misps))
      (setq scal (getvar "dimscale")))
 ; Ŀ
 ;   Ask for an insertion point.                                           
 ; 
  (setq pa (getpoint "Line: "))
  (if (setq pb (osnap pa "near"))                  ; look for a near point
      (setq pa pb))                                ; if one then use it
  (setq psav pa)
 ; Ŀ
 ;   Decide which type of entity we are dealing with, find its angle.      
 ;   A line...                                                             
 ; 
  (cond ((setq ss (ssget pa (list (cons 0 "line"))))
         (setq enam (ssname ss 0))
         (setq entt (entget enam))
         (setq ten (cdr (assoc 10 entt)))
         (setq elv (cdr (assoc 11 entt)))
         (setq angg (angle ten elv))
         (setq angg (/ (* angg 180) pi)))
 ; Ŀ
 ;   Or a polyline.                                                        
 ; 
        ((setq ss (ssget pa '((-4 . "<or") (0 . "polyline")
                              (0 . "lwpolyline") (-4 . "or>"))))
         (setq pb (osnap pa "end"))
         (if (equal pa pb) (setq pa (osnap pa "mid")))
         (setq angg (angle pa pb))
         (setq angg (/ (* angg 180) pi))))
 ; Ŀ
 ;   ...or empty space.                                                    
 ; 
  (if (or (equal angg 90 22) (equal angg 270 22))
      (command "insert" "vwiretagr" psav scal "" "0")
      (command "insert" "hwiretagr" psav scal "" "0"))
 ; Ŀ
 ;   End but leave the Insert command active.                              
 ; 
 (princ))